# -*- coding: utf-8 -*-
"""
Created on Fri Oct  9 16:51:37 2020

@author: koenv
"""
import os
os.chdir(r'C:\Users\koenv\OneDrive - WageningenUR\PHD onedrive\3. Data\Bioreactors parameters\Python')
os.getcwd()

import pandas as pd
#import matplotlib
import matplotlib.pyplot as plt
import numpy as np
from scipy import stats
import string

fn = 'Scatterdata.xlsx'
xl = pd.ExcelFile(fn)
sns = xl.sheet_names
colors = ['C0', 'C1', 'C7']
markers = ["o", "v", "s"]

data = pd.read_excel(fn, sheet_name=sns[0], header=[0,1], index_col=0)

j=0
dlog = {}
dlin = {}
for sn in sns:
    # read data
    data = pd.read_excel(fn, sheet_name=sn, header=[0,1], index_col=0)
    pars = list(data.head()['Removal'])
    xlab = list(data.columns.values)[0]  
    x = list(data[xlab[0]][xlab[1]])  # EBCT or HRT
    dlog['Parameters'] = pars
    dlin['Parameters'] = pars
    
    # make plot
    fig, ax = plt.subplots()
    i = 0
    alog = []
    alin = []
    for par in pars:
        y = list(data['Removal'][par])
        if par == 'TOC':
            x=x[3:-1]
            y=y[3:-1]
        plt.scatter(x, y, s=20, label=par, color=colors[i], marker=markers[i])  #facecolors='none', edgecolors=colors[i],
        r1 = stats.linregress(np.log(x), y) #log regression
        xf = np.linspace(0,max(x),100)
        plt.plot(xf, r1.slope*np.log(xf)+r1.intercept, ':', color=colors[i])
        alog +=  [r1.rvalue**2, r1.slope, r1.intercept]     #R2, intercept, float    
        r2 = stats.linregress(x, y) #lin regression
        alin += [r2.rvalue**2]
        i += 1
    dlog[sn]=alog
    dlin[sn]=alin
    # make up
    plt.xlabel(xlab[1])
    plt.ylabel('EfOM removal (%)')
    plt.ylim(0, 100)
    plt.title(string.ascii_uppercase[j], y=0.9)

    plt.legend()
    j += 1
    
    
    fig.tight_layout()
    plt.show()
    
    fignname = str(sn) + ' scatter.jpg'
    fig.savefig(fignname)

#csv file with R2 data
dflog = pd.DataFrame.from_dict(dlog)
dflin = pd.DataFrame.from_dict(dlin)

writer = pd.ExcelWriter(fn[0:-9] + ' regpars.xlsx', engine='xlsxwriter')
dflog.to_excel(writer, sheet_name='log')
dflin.to_excel(writer, sheet_name='lin')
writer.save()
#savefig(fname, dpi=None, facecolor='w', edgecolor='w',
#        orientation='portrait', papertype=None, format=None,
#        transparent=False, bbox_inches=None, pad_inches=0.1,
#        frameon=None, metadata=None)

